//  $Id: RadixSet.hh 1.7 Sat, 05 Sep 1998 03:59:35 -0700 wlee $
//
//  Copyright (c) 1994 by the University of Southern California
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and its
//  documentation in source and binary forms for lawful non-commercial
//  purposes and without fee is hereby granted, provided that the above
//  copyright notice appear in all copies and that both the copyright
//  notice and this permission notice appear in supporting documentation,
//  and that any documentation, advertising materials, and other materials
//  related to such distribution and use acknowledge that the software was
//  developed by the University of Southern California, Information
//  Sciences Institute. The name of the USC may not be used to endorse or
//  promote products derived from this software without specific prior
//  written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY
//  REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
//  PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
//  TITLE, AND NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT, TORT,
//  OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE
//  OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  ratoolset@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@ISI.EDU>

#ifndef RADIXSET_H
#define RADIXSET_H

#include "config.h"
#include "rpsl/prefix.hh"
#include <cstdio>


#define RADIX_EMPTY 0
#define RADIX_FULL  1


class RadixNode {
public:
   RadixNode() : left(NULL), rght(NULL), prnt(NULL),
      state(RADIX_EMPTY), data(NULL) {}
   RadixNode(RadixNode *p) : left(NULL), rght(NULL), prnt(p),
      state(RADIX_EMPTY), data(NULL){}

   RadixNode *left; // left child
   RadixNode *rght; // right child
   RadixNode *prnt; // parent
      
   int state;   // state == empty is an intermediate node which is not in tree
   void *data;  // 

   RadixNode *insert(void *dt = NULL);
   RadixNode *find(PrefixRange *dt);
   RadixNode *next(); // returns the next rt in radix order

private:
   inline RadixNode *next_i();
};

template <class T>
class Radix : public RadixNode {
public:
   RadixNode *insert(T *dt = NULL) {
     RadixNode::insert(dt);
   }

   T *get_data() {
      return (T *) data;
   }

  void clear(void) { 
    clear(this); 
    left = rght = prnt =  NULL;
    state = RADIX_EMPTY;
    data = NULL;
  }
  void clear(RadixNode *r) {
    if (!r) return;
    if (r->left) clear(r->left);
    if (r->rght) clear(r->rght);
    if (r->data) delete r->data;
  }
};


#endif   // RADIXSET_H
