// $Id: route-list.cc 1.7.1.1 Mon, 15 Dec 1997 14:43:04 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#include "config.hh"
#include "route-list.hh"
#include "dbase.hh"
#include "object.hh"
#include <fstream.h>
#include "roe.hh"
#include "rusage.hh"

Whois RLWhois;

char *RouteList::format(RouteList::Route *vr) {
   static char line[256];
   char *c;

   for (c = line; c < line + vr->indentation; ++c)
      *c = ' ';

   Prefask_map(vr->route).get_address(line + vr->indentation);
   for (c = line + strlen(line); c < line + 31; ++c)
      *c = ' ';
   *c = 0;
	 
   if (vr->reg_status & VR_REGISTERED_NO)
      strcat(line, " NotReg");
   else if (vr->reg_status & VR_REGISTERED_MULTI)
      strcat(line, "       ");
   else if (vr->reg_status & VR_REGISTERED_SINGLY)
      strcat(line, "       ");
   else 
      strcat(line, "  ---  ");


   if (vr->rtd_status & VR_ROUTED_NO)
      strcat(line, " NotRtd");
   else if (vr->rtd_status & VR_ROUTED_YES)
      strcat(line, "       ");
   else 
      strcat(line, "  ---  ");

   if (vr->hmd_status & VR_HOMED_OTHER)
      strcat(line, " OtrHmd");
   else if (vr->hmd_status & VR_HOMED_MULTI_ME)
      strcat(line, " MltHmd");
   else if (vr->hmd_status & VR_HOMED_MULTI_OTHER)
      strcat(line, " MHmOtr");
   else if (vr->hmd_status & VR_HOMED_ME)
      strcat(line, "       ");
   else 
      strcat(line, "  ---  ");

   strcat(line, "    ");

   RouteList::Route::db_as* p;
   for (p = vr->db_as_l.head(); p; p = vr->db_as_l.next(p->db_as_l))
      sprintf(line + strlen(line), "  %s:%s", p->db, p->as);

   return line;
}

void RouteList::display() {
   matching_reg = 0;
   matching_rtd = 0;
   matching_hmd = 0;

   matching_reg |= roe_show_reg_no            ? VR_REGISTERED_NO       : 0;
   matching_reg |= roe_show_reg_single        ? VR_REGISTERED_SINGLY   : 0;
   matching_reg |= roe_show_reg_multi         ? VR_REGISTERED_MULTI    : 0;
   matching_reg |= roe_show_reg_undet         ? VR_REGISTERED_UNDTRMND : 0;
             
   matching_rtd |= roe_show_routed_no         ? VR_ROUTED_NO           : 0;
   matching_rtd |= roe_show_routed_yes        ? VR_ROUTED_YES          : 0;
   matching_rtd |= roe_show_routed_undet      ? VR_ROUTED_UNDTRMND     : 0;
           
   matching_hmd |= roe_show_homed_you         ? VR_HOMED_ME            : 0;
   matching_hmd |= roe_show_homed_other       ? VR_HOMED_OTHER         : 0;
   matching_hmd |= roe_show_homed_multi_me    ? VR_HOMED_MULTI_ME      : 0;
   matching_hmd |= roe_show_homed_multi_other ? VR_HOMED_MULTI_OTHER   : 0;
   matching_hmd |= roe_show_homed_undet       ? VR_HOMED_UNDTRMND      : 0;

   index = 0;
   indent = 0;
   
   //cerr << "measure_now before display" << endl;
   //cerr << ru << endl;
   if (vrdisplayed_size != rlist.size() + 1) {
      vrdisplayed_size = rlist.size() + 1;
      if (vrdisplayed)
	 delete [] vrdisplayed;
      vrdisplayed = new (RouteList::Route*)[vrdisplayed_size];
   }

   tcl_Eval(".routes.list delete 0 end");

   display_i(&radix);

   vrdisplayed[index] = (RouteList::Route *) NULL;

   if (index) { // if there is at least one route, select it
      tcl_Eval(".routes.list selection set 0");
      select(0);
   }
   //cerr << "measure_now after display" << endl;
   //cerr << ru << endl;
}

void RouteList::display_i(RadixNode *rdnode) {
   int oldindent = indent;

   if (!rdnode)
      return;

   if (rdnode->state == RADIX_FULL) {
      RouteList::Route *vr = (Route *) rdnode->data;

      int potential_IBGP = 0;
      if (!roe_show_potential_IBGP) {
	 RouteList::Route *vr1 = vr;
	 RadixNode *parent = rdnode;

	 while (vr1 && parent && ! potential_IBGP && 
		vr1->reg_status & VR_REGISTERED_NO &&
		vr1->rtd_status & VR_ROUTED_YES) {
	    for (parent = parent->prnt; 
		 parent && parent->state != RADIX_FULL; 
		 parent = parent->prnt)
	       ;
	    if (parent) {
	       vr1 = (Route *)parent->data;
	       if (vr1)
		  if (vr1->reg_status & VR_REGISTERED_YES)
		     potential_IBGP = 1;
	    }
	 }
      }

      if (vr->reg_status & matching_reg
	  && vr->rtd_status & matching_rtd
	  && vr->hmd_status & matching_hmd
	  && ! potential_IBGP) {

	 vr->display_index = index;
	 vr->indentation   = indent;
	 vrdisplayed[index++] = vr;

	 tcl_Eval(".routes.list insert end {%s}", format(vr));
	 indent++;
      } else
	 vr->display_index = -1;
   }

   display_i(rdnode->left);
   display_i(rdnode->rght);
   indent = oldindent;
}

void RouteList::select(int index) {
   char buffer[1024];
   char buffer2[64];
   char *buffer3;
   char rc;
   int code;
   int bytes_read;
   RouteList::Route::db_as *p;

   RouteList::Route *vr = vrdisplayed[index];

   tcl_Eval("destroy_children .buttonbar");

   get_registration_now(vr);

   for (p = vr->db_as_l.head(); p; p = vr->db_as_l.next(p->db_as_l)) {
      tcl_Eval("button .buttonbar.a%s:%s -text {%s %s} -command { roe_show_object %s %s %s}", 
	       p->db, p->as, p->db, p->as, p->db, p->as, 
	       Prefask_map(vr->route).get_address(buffer2));
      tcl_Eval("pack .buttonbar.a%s:%s  -side left", p->db, p->as);
   }

   p = vr->db_as_l.head();
   if (p)
      object.display(p->db, p->as, Prefask_map(vr->route).get_address(buffer2));
   else
      object.clear();
}

void RouteList::get_registration_now(RouteList::Route *vr) {
   char buffer[64];
   char *response = NULL;

   if ((vr->status & VR_IRR_QUERIED) || (vr->status & VR_IRR_DONT_QUERY))
      return;

   whois.QueryKillResponse("!ufo=0");
   whois.QueryResponse(response, 
		       "!r%s,o", Prefask_map(vr->route).get_address(buffer));

   if (!response) 
     {
     tcl_Eval("showWarning { No %s on IRR!}", buffer);
     return;
     }
   parse_registration_response(response, vr);
   delete [] response;

   if (vr->display_index != -1) {
      sprintf(buffer, "%d", vr->display_index);
      tcl_Eval(".routes.list delete %s", buffer);
      tcl_Eval(".routes.list insert %s {%s}", buffer, routelist.format(vr));
   }
}

void RouteList::parse_registration_response(char *response, 
					    RouteList::Route *vr) {
   char dbase[64], *line, *next;
   char *as;
   RouteList::Route::db_as *p, *fp;

   vr->status |= VR_IRR_QUERIED;

   next = response;

   while (*next) {
      line = next;
      extern char *my_strchr(char *s, int c);
      if (next = my_strchr(next, '\n')) {
	 *next = 0;
	 next++;
      }

      strcpy(dbase, strtok(line, " \t"));
      for (as = strtok(NULL, " \t"); as; as = strtok(NULL, " \t")) {
	 p = new RouteList::Route::db_as(dbase, as);
	 vr->db_as_l.append(p->db_as_l);
      }      
   }

   switch (vr->db_as_l.size()) {
   case 0:
      vr->reg_status = VR_REGISTERED_NO;
      break;
   case 1:
      vr->reg_status = VR_REGISTERED_SINGLY;
      break;
   default:
      vr->reg_status = VR_REGISTERED_MULTI;
   }

   fp = vr->db_as_l.head();
   if (fp) {
      int multi_homed = 0;
      int homed_to_me = 0;
      for (p = fp; 
	   p; 
	   p = vr->db_as_l.next(p->db_as_l)) {
	 if (strcmp(fp->as, p->as))
	    multi_homed = 1;
	 if (!strcmp(p->as, routelist.as)) 
	    homed_to_me = 1;
      }
	 
      if (multi_homed && homed_to_me)
	 vr->hmd_status = VR_HOMED_MULTI_ME;
      else if (multi_homed)
	 vr->hmd_status = VR_HOMED_MULTI_OTHER;
      else if (homed_to_me)
	 vr->hmd_status = VR_HOMED_ME;
      else
	 vr->hmd_status = VR_HOMED_OTHER;
   }
}

// Make it global -- wlee@isi.edu
int irr_pending_replies;

RouteList::Route *RouteList::get_registration_response() {
   char dbase[64], buffer[1024], *response, *line, *next;
   char *as;
   char last_as[16];
   RouteList::Route *vr, *p;

   if (!routelist.vr_response_next)
      return NULL;

   for (vr = routelist.vr_response_next;
	vr && (vr->status & VR_IRR_DONT_QUERY);
	vr = routelist.rlist.next(vr->rlist))
      ;      

   if (vr) {
      for (p = routelist.rlist.next(vr->rlist);
	   p && (p->status & VR_IRR_DONT_QUERY);
	   p = routelist.rlist.next(p->rlist))
	 ;      
      routelist.vr_response_next = p;
      
      if (! RLWhois.Response(response))
	 return vr;
/*
      char *p;
      if (RLWhois.Response(p))
	{
	cout << p << endl;
	delete p;dddd
	}
*/
      tcl_Eval(".statusbar.right configure -text {Pending Replies: %d}", 
	       --irr_pending_replies);

      if (! (vr->status & VR_IRR_QUERIED))
	 parse_registration_response(response, vr);
      delete [] response;
   } else
      routelist.vr_response_next = NULL;

   return vr;
}

RouteList::Route *RouteList::ask_registration() {
   RouteList::Route *vr;
   char buffer[64];

   if (!routelist.vr_query_next)
      return NULL;

   for (vr = routelist.vr_query_next;
	vr && (vr->status & VR_IRR_DONT_QUERY);
	vr = routelist.rlist.next(vr->rlist))
      ;      

   if (vr) {
      routelist.vr_query_next = routelist.rlist.next(vr->rlist);

      RLWhois.Query("!r%s,o", Prefask_map(vr->route).get_address(buffer));

//      RLWhois.Query("!r%s", Prefask_map(vr->route).get_address(buffer));

   } else 
      routelist.vr_query_next = NULL;

   return vr;
}


void RouteList::get_registrations(ClientData clientdata) {
   char buffer[1024];
   RouteList::Route *vr;

   if (! routelist.vr_response_next && ! routelist.vr_query_next)
      return;

// ???
//   if (! RLWhois.ReadReady()) {
   if (! RLWhois.PendingData()) {
      tcl_Eval("update");
      Tk_DoWhenIdle(get_registrations, (ClientData) NULL);
      return;
   }

   ask_registration();

   if (vr = get_registration_response()) {
      if (vr->display_index != -1) {
	 sprintf(buffer, "%d", vr->display_index);
	 tcl_Eval(".routes.list delete %s", buffer);
	 tcl_Eval(".routes.list insert %s {%s}", buffer, routelist.format(vr));
      }

      if (vr->display_index == 0)
	 routelist.select(0);

      tcl_Eval("update");
   } 

   Tk_DoWhenIdle(get_registrations, (ClientData) NULL);
}

#define PENDING_REQ_WINDOW 45

void RouteList::get_registrations_init(RouteList::Route *first) {
   RouteList::Route *vr1 = (RouteList::Route *) 1;
   RouteList::Route *vr;

   if (!RLWhois.is_open()) {
// Modified by wlee since it's needless to Open() anymore
//      RLWhois.Open(opt_hostname, opt_port, opt_database);
      RLWhois.QueryKillResponse("!ufo=0");
   }

   for (vr = first; vr; vr = rlist.next(vr->rlist))
      if (! (vr->status & VR_IRR_DONT_QUERY))
	 irr_pending_replies++;

   tcl_Eval(".statusbar.right configure -text {Pending Replies: %d}", 
	    irr_pending_replies);

   if (! vr_query_next && first) {
      vr_response_next = first;
      vr_query_next = first;
      for (int i = 0; i < PENDING_REQ_WINDOW && vr1; ++i)
	 vr1 = ask_registration();

      // Changed by wlee@isi.edu
      //      get_registrations((ClientData) NULL);
      Tk_DoWhenIdle(get_registrations, (ClientData) NULL);
   }
}

void RouteList::init(void) {
  // ???
  vrdisplayed = NULL;
  vrdisplayed_size = 0;
  *as = 0;
  vr_query_next = NULL;
  vr_response_next = NULL;
  matching_reg = 0;
  matching_rtd = 0;
  matching_hmd = 0;
  if (irr_radix)
    {
    delete irr_radix;
    irr_radix = NULL;
    }
  registered_routes.clear();
  real_routes.clear();
  rlist.unlink_all();
  radix.clear();
  irr_pending_replies = 0; 
}

void RouteList::load(char *_as) {
   strncpy(as, _as, sizeof(as));

   Pix my_as;
   my_as = AS_map.add_entry(as);
   registered_routes = AS_map.expand(my_as);

   RouteList::Route *vr;

   for (Pix i = registered_routes.first(); i; registered_routes.next(i)) {
      vr = new RouteList::Route(registered_routes(i));
      radix.insert(registered_routes(i), vr);
   }

   // below code is less eficient than above commented code
   // however user interface looks better
   // undo this once expand returns a RadixSet
   for (RadixNode *nd = &radix; nd; nd = nd->next())
      if (nd->state == RADIX_FULL)
	 rlist.append(((Route *) nd->data)->rlist);

   get_registrations_init(rlist.head());
}

void RouteList::read_bgp_dump(char *fname) {
   char r[1024];
   char *status;
   Pix rpix;
   RouteList::Route *vr, *tail;
   ifstream dump(fname);

   tail = rlist.tail();

   extern int readbgpdump(_SetOfPix&);
   extern FILE *bgpin;
   bgpin = fopen(fname, "r");
   if (! bgpin) {
      cerr << "File " << fname << " not found." << endl;
      return;
   }
   readbgpdump(real_routes);
   fclose(bgpin);

   for (vr = rlist.head(); vr; vr = rlist.next(vr->rlist))
      if (real_routes.contains(vr->route))
	 vr->rtd_status = VR_ROUTED_YES;
      else
	 if (! (vr->rtd_status & VR_ROUTED_YES))
	    vr->rtd_status = VR_ROUTED_NO;

   define_irr_radix();

   for (Pix i = real_routes.first(); i; real_routes.next(i)) {
      if (! radix.find(real_routes(i))){
	 vr = new RouteList::Route(real_routes(i));
	 vr->rtd_status = VR_ROUTED_YES;

	 if (! irr_radix->find(vr->route)) {
	    vr->reg_status = VR_REGISTERED_NO;
	    vr->status = VR_IRR_DONT_QUERY;
	 }

	 rlist.append(vr->rlist);
	 radix.insert(real_routes(i), vr);
      }
   }

   display();
   
   if (tail)
      get_registrations_init(rlist.next(tail->rlist));
}

void RouteList::define_irr_radix() {
   //cerr << "measure_now before expand(IRR_ROUTES)" << endl;
   //cerr << ru << endl;
   if (! irr_radix) {
     tcl_Eval("popup_message {This will take 3 to 5 mins to finish, during which, your roe will freeze.  Please be patient!}");

      Pix IRR_ROUTES = Community_map.add_entry("IRR-ROUTES");
      _SetOfPix& irr_routes = Community_map.expand(IRR_ROUTES);

      //cerr << "measure_now after expand(IRR_ROUTES)" << endl;
      //cerr << ru << endl;

      irr_radix = new Radix<Route>;

      for (Pix p = irr_routes.first(); p; irr_routes.next(p))
	 irr_radix->insert(irr_routes(p), NULL);

   }
   //cerr << "measure_now after define_irr_radix()" << endl;
   //cerr << ru << endl;
}

void RouteList::get_more_specifics(char *selection) {
   RouteList::Route *vr;
   Route *tail;

   define_irr_radix();

   tail = rlist.tail();

   for (char *s = strtok(selection, " \t"); s; s = strtok(NULL, " \t")) {
      vr = vrdisplayed[atoi(s)];
      RadixNode *rdnode = irr_radix->find(vr->route);
      if (rdnode) {
	 get_more_specifics_add(rdnode->left);
	 get_more_specifics_add(rdnode->rght);
      }
   }

   //cerr << "measure_now after get_more_specifics_add(t)" << endl;
   //cerr << ru << endl;
   if (tail != rlist.tail()) {
      display();

      if (tail)
	 get_registrations_init(rlist.next(tail->rlist));
   }
}

void RouteList::get_more_specifics_add(RadixNode *rdnode) {
   RouteList::Route *vr;

   if (!rdnode)
      return;

   if (rdnode->state == RADIX_FULL) { // is it actually a route in IRR
      RadixNode *node = radix.find(rdnode->route); 

      if (!node || node->state == RADIX_EMPTY) { // is not in radix
	 vr = new RouteList::Route(rdnode->route);
	 rlist.append(vr->rlist);
	 if (!node)
	    radix.insert(vr->route, vr);
	 else {
	    node->state |= RADIX_FULL;
	    node->route = vr->route;
	    node->data  = vr;
	 }
      }
   }

   if (rdnode->left)
      get_more_specifics_add(rdnode->left);
   if (rdnode->rght)
      get_more_specifics_add(rdnode->rght);
}

void RouteList::get_less_specifics(char *selection) {
   RouteList::Route *vr;
   Route *tail;
   RadixNode *irr_node;
   RadixNode *node;

   define_irr_radix();

   tail = rlist.tail();

   for (char *s = strtok(selection, " \t"); s; s = strtok(NULL, " \t")) {
      vr = vrdisplayed[atoi(s)];
      irr_node = irr_radix->find(vr->route);
      node     = radix.find(vr->route);
      if (irr_node && node) {
	 // add the parents of irr_node
	 for (irr_node = irr_node->prnt, node = node->prnt; 
	      irr_node; 
	      irr_node = irr_node->prnt, node = node->prnt) {
	    if (irr_node->state == RADIX_FULL 
		&& node->state == RADIX_EMPTY) { 
	       // the node exists in irr_radix but not in radix, so add it
	       vr = new RouteList::Route(irr_node->route);
	       rlist.append(vr->rlist);
	       node->state |= RADIX_FULL;
	       node->route = vr->route;
	       node->data  = vr;
	    }
	 }
      }
   }

   if (tail != rlist.tail()) {
      display();

      if (tail)
	 get_registrations_init(rlist.next(tail->rlist));
   }
}

