// $Id: prcheck.cc 1.3 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"
#include <cstdlib>

extern "C" {
#if HAVE_UNISTD_H
#   include <unistd.h>
#endif
}
#include <iostream.h>
#include <iomanip.h>
#include "dbase.hh"
#include "Node.h"
#include "debug.hh"
#include "trace.hh"
#include "rusage.hh"
#include "prcheck.hh"
#include "version.hh"
#include "Argv.hh"

Rusage ru;
Pix my_as_no;

int  opt_rusage        = 0;
//char *opt_prompt       = "prcheck> ";
char *opt_my_as        = NULL;
int  opt_echo_as       = 0;

void usage(char *argv[]) {
   cerr << "Usage: " << argv[0] << " to be written later" << endl;
   exit(1);
}

int start_tracing(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      trace.enable(nextArg);
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0; 
}

int start_debugging(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      Debug(dbg.enable(atoi(nextArg)));
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0;
}

void init_and_set_options (int argc, char **argv, char **envp) {
   ArgvInfo argTable[] = {
      // RAToolSet common arguments
      // key, type, src, dst, help
      {"-T", ARGV_FUNC, (char *) &start_tracing,      (char *) NULL, 
       "Start tracing the next argument"},
      {"-D", ARGV_FUNC, (char *) &start_debugging,    (char *) NULL, 
       "Start debugging the next argument"},
      {"-version", ARGV_FUNC, (char *) &version,      (char *) NULL,
       "Show version"},
      {"-h", ARGV_FUNC, (char *) &Whois::ArgvHost,    (char *) NULL,
       "Host name of the RAWhoisd server"},
      {"-p", ARGV_FUNC, (char *) &Whois::ArgvPort,    (char *) NULL,
       "Port number of the RAWhoisd server"},
      {"-s", ARGV_FUNC, (char *) &Whois::ArgvSources, (char *) NULL,
       "Order of databases"},
      {"-rusage", ARGV_CONSTANT, (char *) 1,          (char *) &opt_rusage,
       "On termination print resource usage"},
//      {"-prompt", ARGV_STRING,  (char *) NULL,        (char *) &opt_prompt,
//       "Prompt"},
      {"-ignore_errors", ARGV_FUNC, (char *)&Whois::IgnoreErrors, (char *)NULL,
       "Ignore IRR error and warning messages"},
      {"-report_errors", ARGV_FUNC, (char *)&Whois::ReportErrors, (char *)NULL,
       "Print IRR error and warning messages"},

      // prcheck specific arguments
      {"-as",  ARGV_STRING,    (char *) NULL,    (char *) &opt_my_as,
       "AS number of the aut-num object to use."},
      {"-echo_as", ARGV_CONSTANT, (char *) 1,    (char *) &opt_echo_as,
       "Print the autnum object"},

      {(char *) NULL, ARGV_END, (char *) NULL, (char *) NULL, (char *) NULL}
   };

   for (char **p = envp; *p != NULL; p++) {
      if (strncmp(*p, "IRR_HOST=", 9) == 0)  {
	 whois.SetDefaultHost(*p + 9);
         continue;
      }
      if (strncmp(*p, "IRR_PORT=", 9) == 0)  {
	 whois.SetDefaultPort(atoi(*p + 9));
         continue;
      }
      if (strncmp(*p, "IRR_SOURCES=", 12) == 0)  {
	 whois.SetDefaultSources(*p + 12);
         continue;
      }
   }

   if (ParseArgv(&argc, argv, argTable, 0) != ARGV_OK) {
      cerr << endl;
      exit(1);
   }

   // if there are remaining arguments
   // the first one is my as number
   switch (argc) {
   case 2 :
      opt_my_as = argv[1];
      break;
   case 1:
      break;
   default:
      cerr << "Wrong number of arguments..." << endl;
      exit(-1);
   }

   // have a prompt only if the input is coming from a tty
//   if (!isatty(fileno(stdin)) || !isatty(fileno(stdout)))
//      opt_prompt = 0;
}

main (int argc, char **argv, char **envp) {
   extern int xxparse();
   AutNum *my_autnum;

   init_and_set_options(argc, argv, envp);

   if (opt_my_as)
      my_as_no = AS_map.add_entry(opt_my_as);
   else {
      ipAddr myip;
      myip.setToMyHost();
      my_as_no = AS_map.add_entry(myip);
   }      

   my_autnum = AS_map.define(my_as_no);

   if (opt_echo_as) {
      cout << AS_map(my_as_no) << endl;
      my_autnum->print();
   }

   if (! irr_parser_had_errors)
      cerr << "Congratulations no errors were found in parsing " 
	   <<  AS_map(my_as_no) << endl;

   if (opt_rusage)
      clog << ru;
}

