//  $Id: peval.cc 1.16 Fri, 18 Jul 1997 15:59:18 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"
#include <cstdlib>

extern "C" {
#if HAVE_UNISTD_H
#   include <unistd.h>
#endif
}
#include <iostream.h>
#include <iomanip.h>
#include "Node.h"
#include "NE.hh"
#include "debug.hh"
#include "trace.hh"
#include "rusage.hh"
#include "Error.hh"
#include "whois.hh"
#include "Argv.hh"
#include "version.hh"

extern int xxparse(void);
extern Whois *parser_db_ptr;
extern FilterNode *Big_Root;
extern Error parser_error;

Rusage ru;

int  opt_symbolic      = 0;
int  opt_expand        = 0;
int  opt_rusage        = 0;
int  opt_exec_arg      = 0;
char *opt_prompt       = "peval> ";

void usage(char *argv[]) {
   cerr << "Usage: " << argv[0] << " to be written later" << endl;
   exit(1);
}

int start_tracing(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      trace.enable(nextArg);
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0; 
}

int start_debugging(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      Debug(dbg.enable(atoi(nextArg)));
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0;
}

int expand_as_macros(char *dst, char *key, char *nextArg) {
   opt_expand |= EXPAND_AS_MACROS;
   return 0;
}

int expand_communities(char *dst, char *key, char *nextArg) {
   opt_expand |= EXPAND_COMMUNITIES;
   return 0;
}

int expand_as(char *dst, char *key, char *nextArg) {
   opt_expand |= EXPAND_AS;
   return 0;
}

int expand_all(char *dst, char *key, char *nextArg) {
   opt_expand |= EXPAND_ALL;
   return 0;
}

int expression(char *dst, char *key, char *nextArg) {
   if (!nextArg) return 0;
   int fd[2];
   if (pipe(fd) == -1) {
      clog << "Error: opening pipe to feed -e argument...\n";
      exit(1);
   }
   write(fd[1], nextArg, strlen(nextArg));
   write(fd[1], "\n", 1);
   close(0);
   if (dup(fd[0]) == -1) {
      clog << "Error: dup'ing pipe to feed -e argument...\n";
      exit(1);
   }
   close(fd[1]);
   opt_exec_arg = 1;
   return 1;
}

void init_and_set_options (int argc, char **argv, char **envp) {
   ArgvInfo argTable[] = {
      // RAToolSet common arguments
      // key, type, src, dst, help
      {"-T", ARGV_FUNC, (char *) &start_tracing,      (char *) NULL, 
       "Start tracing the next argument"},
      {"-D", ARGV_FUNC, (char *) &start_debugging,    (char *) NULL, 
       "Start debugging the next argument"},
      {"-version", ARGV_FUNC, (char *) &version,      (char *) NULL,
       "Show version"},
      {"-h", ARGV_FUNC, (char *) &Whois::ArgvHost,    (char *) NULL,
       "Host name of the RAWhoisd server"},
      {"-p", ARGV_FUNC, (char *) &Whois::ArgvPort,    (char *) NULL,
       "Port number of the RAWhoisd server"},
      {"-s", ARGV_FUNC, (char *) &Whois::ArgvSources, (char *) NULL,
       "Order of databases"},
      {"-rusage", ARGV_CONSTANT, (char *) 1,          (char *) &opt_rusage,
       "On termination print resource usage"},
      {"-prompt", ARGV_STRING,  (char *) NULL,        (char *) &opt_prompt,
       "Prompt"},
      {"-ignore_errors", ARGV_FUNC, (char *)&Whois::IgnoreErrors, (char *)NULL,
       "Ignore IRR error and warning messages"},
      {"-report_errors", ARGV_FUNC, (char *)&Whois::ReportErrors, (char *)NULL,
       "Print IRR error and warning messages"},

      // peval specific arguments
      {"-symbolic",  ARGV_CONSTANT, (char *)1, (char *)&opt_symbolic, 
       "Symbolic"},
      {"-expand_as_macros", ARGV_FUNC, (char *)expand_as_macros, (char *)NULL,
       "Expand AS Macros"},
      {"-expand_communities", ARGV_FUNC, (char *)expand_communities, 
       (char *)NULL, "Expand communities name and dbselectors"},
      {"-expand_as", ARGV_FUNC, (char *)expand_as, (char *)NULL,
       "Expand AS numbers into network lists"},
      {"-expand_all", ARGV_FUNC, (char *)expand_all, (char *)NULL,
       "Expand everything"},
      {"-e", ARGV_FUNC, (char *)expression, (char *)NULL,
       "Expression"},
      {(char *) NULL, ARGV_END, (char *) NULL, (char *) NULL, (char *) NULL}
   };

   for (char **p = envp; *p != NULL; p++) {
      if (strncmp(*p, "IRR_HOST=", 9) == 0)  {
	 whois.SetDefaultHost(*p + 9);
         continue;
      }
      if (strncmp(*p, "IRR_PORT=", 9) == 0)  {
	 whois.SetDefaultPort(atoi(*p + 9));
         continue;
      }
      if (strncmp(*p, "IRR_SOURCES=", 12) == 0)  {
	 whois.SetDefaultSources(*p + 12);
         continue;
      }
   }

   if (ParseArgv(&argc, argv, argTable, ARGV_NO_ABBREV) != ARGV_OK) {
      cerr << endl;
      exit(1);
   }

   // if there are remaining arguments
   // the first one is the expression
   switch (argc) {
   case 2:
      expression(NULL, NULL, argv[1]);
      break;
   case 1:
      break;
   default:
      cerr << "Wrong number of arguments..." << endl;
      exit(-1);
   }

   // have a prompt only if the input is coming from a tty
   if (!isatty(fileno(stdin)) || !isatty(fileno(stdout)) || opt_exec_arg)
      opt_prompt = NULL;

}

void evaluate(FilterNode *node) {
   NormalExpression* result;
   parser_db_ptr = &whois;

   if (!node) // an escape command
      return;

   result = node->Evaluate(opt_symbolic ? 0 : opt_expand);
   if (opt_symbolic && opt_expand)
      result->evaluate(opt_expand);

   if (result) {
      cout << *result << endl;
      delete result;
   }
}

main (int argc, char **argv, char **envp) {
   NormalExpression *ne;

   init_and_set_options(argc, argv, envp);

   if (opt_expand && EXPAND_AS_MACROS)
      regexp::expand_AS_macros();

   xxparse();

   if (opt_prompt)
      cout << endl;
	
   CLASS_DEBUG_MEMORY_PRINT(Set);
   CLASS_DEBUG_MEMORY_PRINT(NormalTerm);
   CLASS_DEBUG_MEMORY_PRINT(NormalExpression);
   CLASS_DEBUG_MEMORY_PRINT(SymbolConjunct);

   if (opt_rusage)
      clog << ru;
}

