// $Id: NT.hh 1.10.2.2 Tue, 25 Nov 1997 19:29:55 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for empty
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef NT_H
#define NT_H

#include "config.hh"
#include <iostream.h>
extern "C" {
#include <sys/types.h>
}

#include "SetOfPrefix.hh"
#include "SetOfSymbol.hh"
#include "SetOfASPath.hh"
#include "debug.hh"
#include "dbase.hh"

#define PRFX 0
#define AS_SYM 1
#define AS_MACROS 2
#define PRFX_MACROS 3
#define AS_PATH 4
#define NT_SET_COUNT 5

extern char *PRFX_format(Pix);
extern char *AS_format(Pix);       
extern char *AS_MACROS_format(Pix);    
extern char *PRFX_MACROS_format(Pix);  

class NormalTerm {
public:
   SetOfPrefix     prfx_set;	 // prfx_set INTERSECTION 
   SetOfSymbol     as_sym;       // as_sym INTERSECTION 
   SetOfSymbol     as_macros;    // as_macros INTERSECTION 
   SetOfSymbol     prfx_macros;  // prfx_macros INTERSECTION 
   SetOfASPath     as_path;      // as_path INTERSECTION

   NormalTerm(NormalTerm& a) : 
      prfx_set(a.prfx_set),
      as_sym(a.as_sym),
      as_macros(a.as_macros),
      prfx_macros(a.prfx_macros),
      as_path(a.as_path) {}
   NormalTerm() : as_sym(&AS_map), 
                  as_macros(&ASMacro_map), 
                  prfx_macros(&Community_map) { 
      as_sym.format = AS_format;       
      as_macros.format = AS_MACROS_format;    
      prfx_macros.format = PRFX_MACROS_format;  
   }
   ~NormalTerm() {
   }

   Set& operator [] (int i) {
      switch (i) {
      case PRFX:
	 return prfx_set;
      case AS_SYM:
	 return as_sym;
      case AS_MACROS:
	 return as_macros;
      case PRFX_MACROS:
	 return prfx_macros;
      case AS_PATH:
	 return as_path;
      default:
	 ASSERT(0);
      }
   }

   friend ostream& operator<<(ostream& stream, NormalTerm& nt);

   void clear();
   void make_universal(int exception = -1);

   int empty() {
      return 
	 prfx_set.empty() && 
	 as_sym.empty() && 
	 as_macros.empty() && 
	 prfx_macros.empty() && 
	 as_path.empty();
   }
   int universal() {
      return 
	 prfx_set.universal() && 
	 as_sym.universal() && 
	 as_macros.universal() && 
	 prfx_macros.universal() && 
	 as_path.universal();
   }

   void evaluate(int expand);
   int find_diff(NormalTerm &other);

   CLASS_DEBUG_MEMORY_HH(NormalTerm);
};

typedef NormalTerm* NormalTermPtr;

#endif   // NT_H

