// $Id: CommunityMap.cc 1.4 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright_SetOfPix(c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"
#include <cstring>
#include <iostream.h>
#include <cstdlib>
#include <cstdio>

#include "PrefaskMap.hh"
#include "CommunityMap.hh"
#include "whois.hh"
#include "Allocator.hh"

void CommunityMap::dump() {
   Pix p, q;

   for (p = first(); p; next(p)) {
      cout << key(p) << " " << contents(p).evaluated << endl;

      for (q = contents(p).value.first(); q; contents(p).value.next(q)) {
	 cout << "    " << Prefask_map((Pix) contents(p).value(q)) << endl;
      }
   }
}

// For every Community Name and DB Selector entry in this symbol table,
// try to expand it to a list of prefasks.  For each prefask, insert it into
// the PrefaskST symbol table.  Each time we do this we get a Pix of the
// prefask entry.  Store this Pix in the _SetOfPix associated with the
// SymTab node we are currently operating on.
_SetOfPix & CommunityMap::expand(Pix p) {
   // Check the evaluated field to see if we've already expanded this entry

   if (! contents(p).evaluated) {
      contents(p).evaluated = 1;

      char buf[100];
      extern Pix char2pix_use_Prefask_map(char *word);
      
      sprintf(buf,"!h%s\n", key(p));
      whois.ParseExpansion((char *) buf, key(p), contents(p).value, 
			   char2pix_use_Prefask_map);
   }

   return contents(p).value;
}

void Comm2AdrPrfx(Pix p, _SetOfPix &PRFXset ) {
   PRFXset |= Community_map.expand(p);
}

void Comm2AdrPrfx( _SetOfPix &CommSet, _SetOfPix &PRFXset ) {
   for(Pix r = CommSet.first(); r; CommSet.next( r ) )
      Comm2AdrPrfx((Pix) CommSet( r ), PRFXset);
}

