//  $Id: TclToggleButton.hh 1.3 Fri, 18 Jul 1997 15:57:04 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): WeeSan Lee (wlee@isi.edu)


#ifndef TCLTOGGLEBUTTON_HH
#define TCLTOGGLEBUTTON_HH

#include "TclCheckButton.hh"

class TclToggleButton : public TclCheckButton
{
  private:
    char *pzcUnCheckString, *pzcCheckString;

  private:
    int label(char *pzcLabel);
    static char *traceProc(ClientData pvData, Tcl_Interp *pcInterp, 
			   char *pzcName1, char *pzcName2, int iFlags);

  protected:
    char *traceProc(void);

  public:
    TclToggleButton(char *pzcName, char *pzcUnCheckString, 
		    char *pzcCheckString, 
		    tdCheckButtonOption eOption = cbUnCheck);
    ~TclToggleButton(void);
    virtual int setExtraArgument(void *pvExtraArgument);
    void labelUnCheckString(char *pzcString) 
       { 
       pzcUnCheckString = pzcString; 
       traceProc();
       }
    void labelCheckString(char *pzcString) 
       { 
       pzcCheckString = pzcString; 
       traceProc();
       }
    void labelBothString(char *pzcString)
       {
       pzcUnCheckString = pzcCheckString = pzcString;
       traceProc();
       }
    void toggle(void);
};

#endif // TCLTOGGLEBUTTON_HH
