//  $Id: f_gated.cc 1.4.2.6 Mon, 02 Feb 1998 18:26:49 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)


#include "config.hh"
#include <cstring>
#include <iostream.h>
#include <iomanip.h>
#include <cctype>
#include "RtConfig.hh"
#include "Node.h"

#define DBG_GATED 7

void gated_export(Pix asno, Pix addr, Pix peer_asno, Pix peer_addr);

void gated_import(Pix asno, Pix addr, Pix peer_asno, Pix peer_addr);

void gated_process_line(int command,
			Pix asno, Pix addr, Pix peer_asno, Pix peer_addr,
			char *name) {
   // disabling printing AS before AS numbers
   re_asno_t no;
   no.prefix_str = "";

   switch (command) {
   case IMPORT_COMMAND :
      gated_import(asno, addr, peer_asno, peer_addr);
      break;
   case EXPORT_COMMAND:
      gated_export(asno, addr, peer_asno, peer_addr);
      break;
   default:
      cerr << "Error: Unknown RtConfig command." << endl;
   }
}

void gated_print_as_path(SetOfASPath &re) {
   regexp *reg = reg->construct(re.re->m);
   cout << *reg;
}

static char *gated_PRFX_format(Pix i) {
   static char buffer[128];
   Prefask &address = Prefask_map(i);

   int2quad(buffer, address.get_prefix());
   sprintf(buffer+strlen(buffer), " masklen %u exact", address.get_length());

   return buffer;
}

void gated_print_net_list(SetOfPrefix &nets, 
			  int pref, int med, int dpa, int import_flag) {
   if (nets.empty())
      return;

   RadixSet::SortedPrefixIterator itr(&nets.members);
   u_int addr;
   u_int leng;
   char buffer[64];

   for (bool ok = itr.first(addr, leng);
	ok;
	ok = itr.next(addr, leng)) {
      if (!import_flag)
	 cout << "   ";
      cout << "   " << int2quad(buffer, addr) 
	   << " masklen " << leng << " exact";
      if (import_flag)
	 if (pref < 0)
	    cout << "\trestrict;\n";
	 else
	    cout << "\tpreference " << pref << ";\n";
      else
	 if (pref == -1)
	    cout << "\trestrict;\n";
	 else {
	    if (med > 0)
	       cout << "\tmetric " << med;
	    if (dpa > 0)
	       cout << "\tDPA " << dpa;
	    cout << ";\n";
	 }
   }
}

class f_gated_node {
public:
   f_gated_node() : result(this) {}
   SetOfASPath  as_path;
   int          contains;

   ListNode     result;
};

class Result {
public:
   Result() : rlist(this) {
      ne = NULL;
   }
   ~Result() {
      if (ne)
	 delete ne;
   }
    
   SetOfASPath* as_path() {
      if (ne && ne->first())
	 return & ne->first()->as_path;
      return NULL;
   }

   SetOfPrefix* prfx_set() {
      if (ne && ne->first())
	 return & ne->first()->prfx_set;
      return NULL;
   }

   NormalExpression *ne;
   int pref;
   int med;
   int dpa;

   ListNode rlist;
};

int add(ListHead<Result> *rlist,
	 NormalExpression *ne1, NormalExpression *ne2, 
	 ActionNode *action1, ActionNode *action2, 
	intintVHMap &pref_map1, intintVHMap &pref_map2) {
   int last = 0;
   extern int get_pref(ActionNode *action1, ActionNode *action2, 
		       intintVHMap &pref_map1, intintVHMap &pref_map2);
   extern int get_med(ActionNode *action1, ActionNode *action2);
   extern int get_dpa(ActionNode *action1, ActionNode *action2);

   ne1->do_and(*ne2);

   // Added by wlee@isi.edu
   delete ne2;

   if (ne1->empty()) 
      return last;

   if (ne1->universal()) 
      last = 1;

   for (NormalTerm *nt = ne1->first(); nt; nt = ne1->next()) {
      Result *r = new Result;
      r->ne = new NormalExpression;
      *(r->ne) += new NormalTerm(*nt);
      r->pref = get_pref(action1, action2, pref_map1, pref_map2);
      r->med  = get_med(action1, action2);
      r->dpa  = get_dpa(action1, action2);
      rlist->append(r->rlist);
   }

   delete ne1;

   return last;
}


void gated_import(Pix asno, Pix addr, Pix peer_asno, Pix peer_addr) {
   ASPolicy *p;
   Filter_Action *fap;
   Filter_Action *ifap;
   InterASPolicy *ip;
   int interas_match;
   AutNum *autnum;

   // define as
   if (!(autnum = AS_map.define(asno))) {
      cerr << "Error: no object for " << AS_map(asno) << endl;
      return;
    }
   
   // find peer as
   if (!(p = autnum->find_peer(peer_asno))) {
      cerr << "Error: " << AS_map(asno) 
	 << " has no policy for " << AS_map(peer_asno) << endl;
      return;
   }

   if (!(fap = p->in.head())) {
      cerr << "Error: " << AS_map(asno) 
	 << " has no import policy for " << AS_map(peer_asno) << endl;
      return;
   }
   
   // find peering
   ip = p->find_peering(addr, peer_addr);
   
   // for each as-in policy
   int last = 0;
   ListHead<Result> rlist;

   // make rlist contain a list of (ne, pref) pairs
   // that will be imported
   for (; fap && !last; fap = p->in.next(fap->falist)) {
      // calculate imports for this interface
      if (ip) // is there an interas-in policy
	 // for each interas-in policy
	 for (ifap = ip->in.head(); 
	      ifap && !last; 
	      ifap = ip->in.next(ifap->falist))
	    last = add(&rlist, 
		       new NormalExpression(*fap->expand()), ifap->expand(), 
		       fap->action, ifap->action,
		       autnum->pref_map, p->ipref_map);
      
      if (!last) // left over policies
	 last = add(&rlist, 
		    new NormalExpression(*fap->expand()), 
		    new NormalExpression(*p->get_remaining_in()), 
		    fap->action, NULL,
		    autnum->pref_map, p->ipref_map);
   }

   if (rlist.is_empty())
      return;

   if (rlist.size() > 32) {
      cerr << "Error: expression is too complicated for gated, contains more than 32 (as-path expression, netlist, pref) triplets, which may cause billions of gated import/export statements..." << endl;
      rlist.clear();
      return;
   }

   // with n (as-path expression, netlist, pref) triplets
   // we have to generate 2^n-1 gated import statements
   // because gated stops after first as path match

   ListHead<f_gated_node> result;
   f_gated_node *node, *nptr;
   unsigned int fill;
   unsigned int i;
   Result *r;

   for (i = 1, r = rlist.head(); r; r = rlist.next(r->rlist), i <<= 1) {
      for (nptr = result.head(); nptr; nptr = result.next(nptr->result))
	 if (r->as_path() && nptr->as_path == *r->as_path())
	    break;
      if (nptr)
	 nptr->contains |= i;
      else {
	 node = new f_gated_node;
	 node->as_path = *r->as_path();
	 node->contains = i;
	 result.append(node->result);
      }
      Debug(Channel(DBG_GATED) << hex << i << "\n");
   }

   for (nptr = result.head(); nptr; nptr = result.next(nptr->result)) {
      for (fill = 0, i = 1, r = rlist.head(); 
	   r; 
	   r = rlist.next(r->rlist), fill |= i, i <<= 1) {
	 Debug(Channel(DBG_GATED) << nptr->contains << " " << i << " ");
	 if (!(nptr->contains & i) && !(nptr->contains & fill)) {
	    node = new f_gated_node;
	    node->as_path = nptr->as_path;
	    node->as_path &= *r->as_path();
	    if (!node->as_path.empty()) {
	       node->contains = nptr->contains | i;
	       result.append(node->result);
	       Debug(Channel(DBG_GATED) << hex << node->contains);
	    } else
	       delete node;
	 }
	 Debug(Channel(DBG_GATED) << "\n");
      }
   }

   SetOfASPath as_path_covered, tmp_as_path;

   for (nptr = result.tail(), last = 0; 
	nptr && !last; 
	nptr = result.prev(nptr->result)) {
      if (!nptr->as_path.universal()) {
	 tmp_as_path = as_path_covered;
	 ~tmp_as_path;
	 nptr->as_path &= tmp_as_path;
      }
      if (!nptr->as_path.empty()) {
	 tmp_as_path = nptr->as_path;
	 as_path_covered |= tmp_as_path;
	 last = as_path_covered.universal();
	 cout << "import proto bgp ";
	    
	 if (result.size() == 1 && nptr->as_path.universal())
	    cout << "as " << (AS_map(peer_asno) + 2) << " {\n";
	 else {
	    cout << "aspath ";
	    gated_print_as_path(nptr->as_path);
	    cout << " origin any {\n";
	 }

	 // now print the network lists
	 SetOfPrefix nets_covered;	 
	 int all_pref = -1;
	 int all_med  = -2;
	 int all_dpa  = -2;
	 int include;
	 SetOfPrefix prfx;
	 for (include = nptr->contains, r = rlist.head();
	      r; 
	      r = rlist.next(r->rlist), include >>= 1)
	    if (include & 1) {
	       prfx = *r->prfx_set();
	       ~nets_covered;
	       prfx &= nets_covered;
	       ~nets_covered;
	       if (!prfx.empty()) {
		  nets_covered |= prfx;
		  if (all_pref == -1 
		      && (nets_covered.negated() || nets_covered.universal())) {
		     all_pref = r->pref;
		     all_med  = r->med;
		     all_dpa  = r->dpa;
		  } else 
		     gated_print_net_list(prfx, r->pref, r->med, r->dpa, 1);
	       }
	    }
	 if (all_pref == -1) 
	    cout << "   all restrict;\n";
	 else {
	    if (nets_covered.negated()) {
	       ~nets_covered;
	       gated_print_net_list(nets_covered, -1, -2, -2, 1);
	    }
	    cout << "   all preference " << all_pref << ";\n";
	 }
	 cout << "};\n\n";
      }
   }

   result.clear();
   rlist.clear();
}


void gated_export(Pix asno, Pix addr, Pix peer_asno, Pix peer_addr) {
   ASPolicy *p;
   Filter_Action *fap;
   Filter_Action *ifap;
   InterASPolicy *ip;
   int interas_match;
   AutNum *autnum;

   // define as
   if (!(autnum = AS_map.define(asno))) {
      cerr << "Error: no object for " << AS_map(asno) << endl;
      return;
    }
   
   // find peer as
   if (!(p = autnum->find_peer(peer_asno))) {
      cerr << "Error: " << AS_map(asno) 
	 << " has no policy for " << AS_map(peer_asno) << endl;
      return;
   }

   if (!(fap = p->out.head())) {
      cerr << "Error: " << AS_map(asno) 
	 << " has no export policy for " << AS_map(peer_asno) << endl;
      return;
   }
   
   // find peering
   ip = p->find_peering(addr, peer_addr);
   
   // for each as-out policy
   int last = 0;
   ListHead<Result> rlist;

   // make rlist contain a list of (ne, pref) pairs
   // that will be exported
   for (; fap && !last; fap = p->out.next(fap->falist)) {
      // calculate exports for this interface
      if (ip) // is there an interas-out policy
	 // for each interas-out policy
	 for (ifap = ip->out.head(); 
	      ifap && !last; 
	      ifap = ip->out.next(ifap->falist))
	    last = add(&rlist, 
		       new NormalExpression(*fap->expand()), ifap->expand(), 
		       fap->action, ifap->action,
		       autnum->pref_map, p->ipref_map);
      
      if (!last) // left over policies
	 last = add(&rlist, 
		    new NormalExpression(*fap->expand()), 
		    new NormalExpression(*p->get_remaining_out()), 
		    fap->action, NULL,
		    autnum->pref_map, p->ipref_map);
   }

   if (rlist.is_empty())
      return;

   if (rlist.size() > 32) {
      cerr << "Error: expression is too complicated for gated, contains more than 32 (as-path expression, netlist, pref) triplets, which may cause billions of gated import/export statements..." << endl;
      rlist.clear();
      return;
   }

   // with n (as-path expression, netlist, pref) triplets
   // we have to generate 2^n-1 gated export statements
   // because gated stops after first as path match

   ListHead<f_gated_node> result;
   f_gated_node *node, *nptr;
   unsigned int fill;
   unsigned int i;
   Result *r;

   for (i = 1, r = rlist.head(); r; r = rlist.next(r->rlist), i <<= 1) {
      for (nptr = result.head(); nptr; nptr = result.next(nptr->result))
	 if (r->as_path() && nptr->as_path == *r->as_path())
	    break;
      if (nptr)
	 nptr->contains |= i;
      else {
	 node = new f_gated_node;
	 node->as_path = *r->as_path();
	 node->contains = i;
	 result.append(node->result);
      }
      Debug(Channel(DBG_GATED) << hex << i << "\n");
   }

   for (nptr = result.head(); nptr; nptr = result.next(nptr->result)) {
      for (fill = 0, i = 1, r = rlist.head(); 
	   r; 
	   r = rlist.next(r->rlist), fill |= i, i <<= 1) {
	 Debug(Channel(DBG_GATED) << nptr->contains << " " << i << " ");
	 if (!(nptr->contains & i) && !(nptr->contains & fill)) {
	    node = new f_gated_node;
	    node->as_path = nptr->as_path;
	    node->as_path &= *r->as_path();
	    if (!node->as_path.empty()) {
	       node->contains = nptr->contains | i;
	       result.append(node->result);
	       Debug(Channel(DBG_GATED) << hex << node->contains);
	    } else
	       delete node;
	 }
	 Debug(Channel(DBG_GATED) << "\n");
      }
   }

   SetOfASPath as_path_covered, tmp_as_path;

   for (nptr = result.tail(), last = 0; 
	nptr && !last; 
	nptr = result.prev(nptr->result)) {
      if (!nptr->as_path.universal()) {
	 tmp_as_path = as_path_covered;
	 ~tmp_as_path;
	 nptr->as_path &= tmp_as_path;
      }
      if (!nptr->as_path.empty()) {
	 tmp_as_path = nptr->as_path;
	 as_path_covered |= tmp_as_path;
	 last = as_path_covered.universal();
	 cout << "   proto bgp ";
	    
	 if (result.size() == 1 && nptr->as_path.universal())
	    cout << "aspath .* origin any {\n";
	 else {
	    cout << "aspath ";
	    gated_print_as_path(nptr->as_path);
	    cout << " origin any {\n";
	 }
	
	 // now print the network lists
	 SetOfPrefix nets_covered;	 
	 int all_pref = -1;
	 int all_med  = -2;
	 int all_dpa  = -2;
	 int include;
	 SetOfPrefix prfx;
	 for (include = nptr->contains, r = rlist.head();
	      r; 
	      r = rlist.next(r->rlist), include >>= 1)
	    if (include & 1) {
	       prfx = *r->prfx_set();
	       ~nets_covered;
	       prfx &= nets_covered;
	       ~nets_covered;
	       if (!prfx.empty()) {
		  nets_covered |= prfx;
		  if (all_pref == -1 
		      && (nets_covered.negated() || nets_covered.universal())) {
		     all_pref = r->pref;
		     all_med  = r->med;
		     all_dpa  = r->dpa;
		  } else 
		     gated_print_net_list(prfx, r->pref, r->med, r->dpa, 0);
	       }
	    }
	 if (all_pref == -1) 
	    cout << "      all restrict;\n";
	 else {
	    if (nets_covered.negated()) {
	       ~nets_covered;
	       gated_print_net_list(nets_covered, -1, -2, -2, 0);
	    }
	    cout << "      all";
	    if (all_med >= 0) 
	       cout << " metric " << all_med;
	    if (all_dpa >= 0)
	       cout << " DPA " << all_dpa;
	    cout << ";\n";
	 }
	 cout << "   };\n\n";
      }
   }

   result.clear();
   rlist.clear();
}


